#include <stdio.h>

#define SIZE 3

#define EMPTY 0
#define P_X 1
#define P_O -1


/* Definizione dei tipi */
typedef struct point {
    int x;
    int y;
} point_t;

/* Definizione della matrice */
char mat[SIZE][SIZE];
int n_round=0;

/* Prototipi */
void stampa_matrice();
char verifica_vittoria(void);
point_t chiedi_mossa(void);
point_t chiedi_mossa_ai(char giocatore);

/* Funzioni */
void stampa_matrice() {
    printf("\nRound: %d\n", n_round);
    printf("x/y 0 1 2\n");

    int i,j;
    for (i=0; i<SIZE; i++) {
        printf("  %d ", i);
        for (j=0; j<SIZE; j++) {
            switch(mat[i][j]) {
                case EMPTY:
                    putchar('_');
                break;
                case P_X:
                    putchar('X');
                break;
                case P_O:
                    putchar('O');
                break;
                default:    // Non dovrebbe mai accadere
                    putchar('?');
                break;
            }
            putchar(' ');
        }
        printf("\n");
    }
    printf("\n");
}

point_t chiedi_mossa(void) {
    point_t ret;

    char continua = 1;
    while(continua) {
        printf("Inserisci coordinate x,y: ");
        scanf("%d,%d", &ret.x, &ret.y);

        if (ret.x < 0 || ret.x >= SIZE || ret.y < 0 || ret.y >= SIZE) {
            printf("Invalido\n");
            continue;
        }

        if (mat[ret.x][ret.y] != EMPTY) {
            printf  ("Casella occupata\n");
            continue;
        }

        continua = 0;
    }

    return ret;
}

char verifica_vittoria(void) {
    int tot_rig;  // Se vince P1 sarà 3, altrimenti -3 se vince P2
    int tot_col;  // Se vince P1 sarà 3, altrimenti -3 se vince P2
    int tot_diag_1=0; // Se vince P1 sarà 3, altrimenti -3 se vince P2
    int tot_diag_2=0; // Se vince P1 sarà 3, altrimenti -3 se vince P2

    int i,j;

    for (i=0; i<SIZE; i++) {
        tot_rig=0;
        tot_col=0;

        for (j=0; j<SIZE; j++) {
            tot_rig += mat[i][j];
            tot_col += mat[j][i];
        }

        if (tot_rig == SIZE || tot_col == SIZE) {
            return P_X;
        }

        if (tot_rig == -SIZE || tot_col == -SIZE) {
            return P_O;
        }

        tot_diag_1 += mat[i][i];
        tot_diag_2 += mat[i][SIZE-i-1];
    }

    if (tot_diag_1 == SIZE || tot_diag_2 == SIZE) {
        return P_X;
    }

    if (tot_diag_1 == -SIZE || tot_diag_2 == -SIZE) {
        return P_O;
    }

    return EMPTY;
}

int calcola_punteggio(int n_round, char giocatore, point_t* best_move) {
    char p_vittoria = verifica_vittoria();

    if (p_vittoria == giocatore) {
        // Vince "giocatore"
        return 1;
    } else {
        if (p_vittoria != EMPTY) {
            // Vince "l'altro giocatore"
            return -1;
        }
    }

    if (n_round == SIZE*SIZE) {
        // Partita "patta"
        return 0;
    }

    // Non vince nessuno per ora, eseguiamo un'altra mossa

    int i,j;
    int score;
    int max_score=-1000;

    for (i=0; i < SIZE; i++) {
        for (j=0; j < SIZE; j++) {
            if (mat[i][j] == EMPTY) {
                mat[i][j] = giocatore;

                score = - calcola_punteggio(n_round+1, giocatore == P_X ? P_O : P_X, NULL);

                if (score > max_score) {
                    max_score = score;
                    if (best_move != NULL) {
                        best_move->x = i;
                        best_move->y = j;
                    }
                }
                mat[i][j] = EMPTY;
            }
        }
    }


    return max_score;

}

point_t chiedi_mossa_ai(char giocatore) {

    point_t best_move;

    best_move.x = -1;
    best_move.y = -1;

    calcola_punteggio(n_round, giocatore, &best_move);

    if (best_move.x == -1) {
        printf("ERRORE\n");
    }

    return best_move;

}

/* main() */
int main() {
    char giocatore_corrente = P_X;
    char p_vittoria = EMPTY;
    int i;
    point_t p;
 
    stampa_matrice();

    for(i=0; i<9; i++) {

	n_round = i;

        if (giocatore_corrente == P_X) {
            p = chiedi_mossa();
        } else {
            p = chiedi_mossa_ai(P_O);
        }

        mat[p.x][p.y] = giocatore_corrente;

        stampa_matrice(i+1);

        p_vittoria = verifica_vittoria();

        if (p_vittoria != EMPTY) {
            printf("VITTORIA! Vince il giocatore %c\n", p_vittoria == P_X ? 'X' : 'O');
            break;
        }

        giocatore_corrente = giocatore_corrente == P_X ? P_O : P_X;
    }

    if (p_vittoria == EMPTY) {
        printf("PATTA!\n");
    }

}
