#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#define PIENO '#'
#define VUOTO ' '
#define LATO 23
#define GENERAZIONI 100

void svuota(char m[LATO][LATO]){
    int i,j;
    for(i=0; i < LATO; i++){
        for(j=0; j < LATO;j++){
               m[i][j] = VUOTO;
        }
    }
}

void glider(char m[LATO][LATO]){
    m[0][1] = PIENO;
    m[1][2] = PIENO;
    m[2][0] = PIENO;
    m[2][1] = PIENO;
    m[2][2] = PIENO;
}


void riempi(char m[LATO][LATO]){
    int i,j;
    srand(100);
    for(i=0; i < LATO; i++){
        for(j=0; j < LATO;j++){
            if ( rand() > (RAND_MAX/10) ){
               m[i][j] = VUOTO;
            } else{
               m[i][j] = PIENO;
            }
        }
    }
}

void pulisci_video(){
    puts("\033[2J");
}

void stampa(char m[LATO][LATO]){
    int i,j;
    for(i=0; i < LATO; i++){
        for(j=0; j < LATO;j++){
            putchar(m[i][j]);
        }
        putchar('\n');
    }
    return;
}

char evolvi(int i_cella, 
            int j_cella, 
            char mondo[LATO][LATO]){
    int vicini=0;
    int i_circ, j_circ, i_controllo, j_controllo;
    for(i_controllo = i_cella-1; 
        i_controllo <= i_cella+1; 
        i_controllo++){
       for(j_controllo = j_cella-1; 
           j_controllo <= j_cella+1; 
           j_controllo++){
           i_circ = (i_controllo+LATO) % LATO;
           j_circ = (j_controllo+LATO) % LATO;
           if ( (mondo[i_circ][j_circ] == PIENO) && 
                !( (j_controllo == j_cella) &&  
                   (i_controllo == i_cella)   ) 
              ){
                vicini = vicini + 1;  
            }
       }
    }
    if(mondo[i_cella][j_cella] == PIENO){
        if ((vicini >= 2) && (vicini <= 3)){
            return PIENO;
        } else {
            return VUOTO;
        }
    } else {
        if(vicini == 3){
            return PIENO;
        } else {
            return VUOTO;
        }
    }
}


int main(int argc,char* argv[]){
    char mondo[LATO][LATO] = {{0}};
    char mondo_s[LATO][LATO] = {{0}};

    svuota(mondo);
    glider(mondo);

    int generazione,i,j;
    for(generazione=0; generazione < GENERAZIONI;generazione++){
        pulisci_video();
        stampa(mondo);

        for(i=0;i<LATO;i++){
            for(j=0;j<LATO; j++){
                mondo_s[i][j] = evolvi(i,j,mondo);
            }
        }

        for(i=0; i<LATO; i++){
            for(j=0; j<LATO; j++){
                mondo[i][j] = mondo_s[i][j];
            }
        }
         sleep(1);
    }
    return 0;
}
