//
//  main.c
//  masterMind
//
//  Created by ing.conti on 08/04/2019.
//  Copyright © 2019 ing.conti. All rights reserved.
//

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>


#define YELLOW  'y'
#define RED     'r'
#define CYAN    'c'
#define MAGENTA 'm'
#define GREEN   'g'
#define ORANGE  'o'

#define MAX_COLORS 6
#define DIM_SOLUZIONE 4

char solution[DIM_SOLUZIONE] = {' '};

int len(char *s){
    int i;
    for (i=0; s[i]!=0 ; i++) {
    }
    return i;
}


int uguali(char s1[], char s2[]){
    int i;
    for (i=0; s1[i]!=0 ; i++) {
        if (s1[i] != s2[i])
            return 0;
    }
    return 1;
}

void compact(char *s){
    int i;
    for (i=0; s[i]!=0 ; i++) {
        s[i] = s[i+1];
    }
}


void BuildSolution(){
    time_t t;
    /* Intializes random number generator */
    srand((unsigned) time(&t));
    int  i = 0;
    
    char initialColors[MAX_COLORS+1] = {
        YELLOW,
        RED,
        CYAN,
        MAGENTA,
        GREEN,
        ORANGE,
        0
    };
    
    for( i = 0 ; i < DIM_SOLUZIONE ; i++ ) {
        int colorIndex = rand() % len(initialColors);
        solution[i] = initialColors[colorIndex];
        compact(initialColors+colorIndex);
        
    }
}

void myprint(char s[]){
    int i;
    for (i=0; s[i]!=0 ; i++) {
        putchar(s[i]);
    }
}

void yellow(){
    myprint("\033[1;33m");
}
void red(){
    myprint("\033[1;31m");
}
void cyan(){
    myprint("\033[1;34m");
}
void magenta(){
    myprint("\033[1;35m");
}
void green(){
    myprint("\033[1;32m");
}
void orange(){
    //gray.... :(
    myprint("\e[0;37m");
}

void reset(){
    myprint("\033[0m");
}

void TestColors(){
    yellow();    myprint("*\n");
    red();       myprint("*\n");
    cyan();      myprint("*\n");
    magenta();    myprint("*\n");
    green();     myprint("*\n");
    orange();    myprint("*\n");

}

void setcolor(char c){
    switch (c) {
        case YELLOW:
            yellow();
            break;
        case RED:
            red();
            break;
        case CYAN:
            cyan();
            break;
        case MAGENTA:
            magenta();
            break;
        case GREEN:
            green();
            break;
        case ORANGE:
            orange();
            break;
        default:
            break;
    }
    
}

void endOfGame(){
    int i=0;
     for( i = 0 ; i < DIM_SOLUZIONE ; i++ ) {
         setcolor(solution[i]);
         putchar(solution[i]);
     }
    
    reset();
    putchar('\n');
}

void leggi(char *s){
    int i=0;
    for( i = 0 ; i < DIM_SOLUZIONE ; i++ ) {
        s[i] = getchar();
    }
    s[i] = 0;
}

int main(int argc, const char * argv[]) {
   
    //TestColors();
    //char test[] = "12A345";
    //compact(test+2);
    //int ug = uguali("AA", "AA");
    int fine = 0;
    char risp[DIM_SOLUZIONE] = "";
    BuildSolution();
    
    //only fort test... endOfGame();

    while (!fine){
        leggi(risp);
        // stampa pin bianchi e neri....
        fine = uguali(risp, solution);
    }
    endOfGame();
    myprint("YOU WON\n");
    return 0;
}
