# Ricorsione

# La ricorsione è una tecnica per modellare algoritmi e scrivere programmi
# che sfrutta l' idea di risolvere un problema utilizzando una soluzione
# a una versione ridotta del problema stesso

# Molti costrutti matematici hanno una definizione naturalmente ricorsiva
# e.g. il numero naturale n è definito come il successore del numero naturale
# n-1, che a sua volta è il successore di n-2 ....
# In sintesi, un naturale è 0 o un numero n+1 dove n è un naturale

# Operativamente: in Python è possibile che una funzione, all' interno 
# della sua esecuzione, richiami sè stessa.
# Questo fa sì che l' esecuzione del calcolo del problema principale venga 
# sospesa per calcolare la soluzione di un problema più piccolo

def calcola_nat(n):
    if (n==1):
        return 1
    return calcola_nat(n-1)+1

print(calcola_nat(5))

# Similmente, il fattoriale può essere definito come
# 0! = 1
# n! = n*(n-1)!
def fact(n):
    if (n==0):
        return 1
    return n*fact(n-1)

print(fact(5))

# palindromi

def palindromo(s):
    if (len(s)<=1):
        return True
    else:
        return (s[0] == s[len(s)-1]) and palindromo(s[1:-1])

#print(palindromo("anna"))
#print(palindromo("radar"))
#print(palindromo("ananas"))

# ricordiamo l' identità di euclide mcd(a,b) = mcd(b, a%b), con a, b != 0, a > b
def mcd(a,b):
    ## opzionale
    if (b>a):
        return mcd(b,a)
    if (b==0):
        return a
    else:
        return mcd(b,a%b)
print(mcd(60,6))

## ricerca binaria
def ricerca_binaria(l,e):
    if(len(l)==0):
        return False
    mid=len(l)//2
    if(l[mid] == e):
        return True
    elif(l[mid] > e):
        return ricerca_binaria(l[:mid],e)
    else:
        return ricerca_binaria(l[mid+1:],e)
lista=[1,2,7,18,20,21]

print("Trovato:" + str(ricerca_binaria(lista,1)))

## Torre di Hanoi
def stampa_stato(stato, max_dischi):
    for i in range(max_dischi-1,-1,-1):
        for piolo in range(3):
            if(len(stato[piolo]) > i):
                print(" "+str(stato[piolo][i]),end="")
            else:
                print(" |",end="")
        print("")
    print("-------")

def hanoi(stato,dischi,da,a,attrav):
    if (dischi == 1):
        estratto = stato[da].pop()
        stato[a].append(estratto)
    else:
        if(dischi==3):
            stampa_stato(stato,dischi_tot)
        hanoi(stato,dischi-1,da,attrav,a)
        #hanoi(stato,1,da, a, attrav)
        if(dischi==3):
            stampa_stato(stato,dischi_tot)
        estratto = stato[da].pop()
        stato[a].append(estratto)        
        if(dischi==3):
            stampa_stato(stato,dischi_tot)
        hanoi(stato,dischi-1,attrav,a,da)
        if(dischi==3):
            stampa_stato(stato,dischi_tot)
    return stato

dischi_tot=3
stato=[[3,2,1], [], []]

stampa_stato(stato,dischi_tot)
hanoi(stato,dischi_tot,0,2,1)
