# Cenni riguardanti gli oggetti
# Oggetto: semplificando un po', si tratta di collezione di variabili e 
# definizioni di funzioni, con un etichetta
# Intuitivamente, il tipo di un oggetto dipende da ciò che contiene. 
# Si dice che un oggetto appartiene a una certa classe.
# La classe quindi indica una sorta di "prototipo" per gli oggetti appartenenti
# ad essa.

# In python, dichiariamo una nuova classe tramite la parola chiave class, seguita
# dal nome e da due punti. Segue, rientrato di uno spazio tutto quello che fa
# parte del contenuto di un oggetto appartenente alla classe: funzioni 
# (dette anche metodi di classe) e variabili (dette anche membri della classe) 

# esempio con classe che descrive i numeri complessi
from math import sqrt
class Complex:
    re = 0
    im = 0
    def modulus(self):
        modulus = sqrt(self.re**2+self.im**2)
        return modulus
    def __repr__(self):
        return str(self.re) + " + " + str(self.im)+ "i"  
    def __add__(self,other):
        if( type(other) != type(Complex())):
            print("tentativo di sommare complessi e altre cose")
            return 
        res = Complex()
        res.re = self.re + other.re
        res.im = self.im + other.im
        return res
      
# Per creare un oggetto appartenente alla classe (ovvero creare un'istanza 
# della classe) si usa la seguente sintassi
x = Complex()

#si accede alle variabili contenute usando la dot notation
print(x.re)
x.re = 1
print(x.re)
x.im = 1
print(x.modulus())
print(x)

#si invocano le funzioni ( che hanno sempre come argomento implicito l' 
#oggetto stesso) con la dot-notation
x.modulus()

# la stampa di un oggetto generico, non è supportata, ma possiamo cambiare
# questa cosa definendo la funzione __repr__ per quella classe
print(x)
print(x.r)

# neppure gli operatori funzionano, solitamente, ma possiamo farli funzionare
# definendo l' opportuna funzione. Ad esempio __add__ per l' addizione
y= Complex()
y.re=0
y.im=10
print(x+y)
print(x+5)


##############################################################################
# Files, interfaccia per leggere, scrivere, modificare files.
# L' astrazione attraverso cui si manipolano i file in python è quella di un 
# oggetto creato dalla funzione open, quando viene invocata


# Aprire un file: segnalare al sistema operativo l' intenzione di operare sui
# contenuti di un file (eventualmente creandolo se non esiste). Si usa la 
# funzione open.

# Modalità di apertura di un file:
#  "r" - sola lettura
#  "w" - sola scrittura, sovrascrive, crea se non esistente
#  "a" scrittura, aggiunge in coda
#  "r+" - lettura e scrittura
# aggiunta di "b" per effettuare lettura dei byte grezzi ( in alcuni sistemi
# operativi coincide con la lettura normale )

# risultato: crea un oggetto file che ne contiene lo stato (dove siamo arrivati
# a leggere/scrivere; se è aperto o meno)

# apertura di un file, creando l' oggetto "diario"
diario = open("diario.txt", "r+")
# arrivati qui il file è pronto per essere usato

# lettura di 5 caratteri tramite la funzione read
letto = diario.read(5)
print("--"+letto+"--")

# lettura di 5 (ulteriori!) caratteri tramite la funzione read
letto = diario.read(5)
print("--"+letto+"--")


# alla fine dell' utilizzo, il file va chiuso: segnala al sistema operativo
# di completare la scrittura effettiva su disco dei contenuti di cui abbiamo chiesto
# la scrittura e consente di sbloccare eventuali altri programmi in attesa di 
# lavorare su esso (e.g., rimozione dischi USB)

# la chiusura si effettua con la funzione close
diario.close()

# l' oggetto diario non viene distrutto dalla close, è ancora presente.
# esso contiene una variabile booleana, closed , vera se il file corrispondente
# all' oggetto è chiuso
print(diario.closed)

# Da non fare, assolutamente:
# diario.closed = True
# non chiude il file, semplicemente fa credere che sia chiuso al programmatore.
#print(diario)
#print(diario.closed)



# leggere tutto il contenuto di un file in una volta
ingresso = open("in_text.txt", "r")
contenuto = ingresso.read()
print(contenuto)
ingresso.close()

# leggere una riga del file
ingresso = open("in_text.txt", "r")
contenuto = ingresso.readline()
print(contenuto)
ingresso.close()

# l' oggetto file è iterabile, posso scrivere un ciclo for che itera sulle
# righe del testo nel file
ingresso = open("in_text.txt", "r")
for riga in ingresso:
    #print( riga.rstrip("'. \n\r") )
    # rstrip rimuove caratteri "bianchi" (spazio, a-capo, tabulazione dal lato 
    # destro (RightSTRIP) della stringa)
    print( riga.rstrip())
ingresso.close()


# esempio: stampare tutte le parole della prima riga del file, circondate 
# da asterischi, una per riga:
ingresso = open("in_text.txt", "r")
riga = ingresso.readline()
# split suddivide una stringa spezzandola ogniqualvolta incontra un carattere
# presente nella stringa data come parametro. Nell' esempio di seguito, spezza
# lungo gli spazi
lista = riga.split(" ")
for parola in lista:
    print("*"+parola+"*")

# E' possibile interrogare l' oggetto che rappresenta la mia astrazione del file, 
# chiedendo quanti caratteri sono stati letti:
print(ingresso.tell())


# E' possibile spostare il cursore, ovvero il punto dove si è arrivati a leggere/scrivere 
# la funzione è la  seek(offset, whence). 
# whence pari a 0 indica uno spiazzamento a partire dall' inizio del file, pari a 
# 1 indica la posizione corrente e 2 indica la fine file. 
# se whence è omesso, la funzione seek assume 0
ingresso.seek(0,0) # torna all' inizio
ingresso.seek(0,1) # resta dov'è
ingresso.seek(5,1) # va avanti di 5 caratteri da dove sono ora 
ingresso.seek(-5,1) # torna indietro di 5 caratteri
ingresso.seek(0,2) # va alla fine del file
ingresso.seek(0) # torna all' inizio del file
ingresso.close()

# Per scrivere su file, si usa la funzione write, accetta un parametro di tipo
# stringa
uscita = open("diario.txt", "r+")
uscita.seek(0,2)
testo_da_scrivere = str(2)
uscita.write(testo_da_scrivere)
# equivalente a 
#uscita.write(str(2))
uscita.close()

# Esempio: stampare le tabelline su file
uscita = open("tabelline.txt","w")
for tab in range(1,11):
    for elem in range(1,11):
        res= elem*tab
        uscita.write(str(res)+" ")
    uscita.write("\n")
uscita.close()

# Python dispone di una libreria pronta per salvare e leggere liste come 
# formato CSV (comma separated values)
# il formato CSV è un formato testuale in cui si specificano liste di
# dati, una lista per rigo, con elementi separati da virgole.

# la libreria contenente quanto necessario si chiama csv
import csv

# per leggere un file CSV, va, come prima cosa aperto regolarmente
csv_ingresso = open("Sedi_Universitarie_della_Lombardia.csv","r+")
# si crea in seguito un oggetto con la funzione reader della libreria csv
# questa prende come parametro l' oggetto restituito dalla open e crea
# un oggetto opaco "lettore di CSV"
reader = csv.reader(csv_ingresso)

# l' oggetto "lettore di CSV" è iterabile: a ogni iterazione fornisce
# il contenuto di una riga del file CSV, sotto forma di lista, contenente
# la sequenza di elementi contenuti in una riga del file CSV
for elem in reader:
    print(elem[3])


# una volta completata l' iterazione, è sufficiente chiudere il file    
csv_ingresso.close()

# si può ottenere tramite la funzione writer della libreria CSV, un analogo oggetto
# scrittore di CSV. il metodo writerow di questo oggetto, acceta una lista
# e la scrive su file come una riga di elementi separati da virgola

#esercizio: scrivere un file contenente le tabelline, in formato CSV
#import csv
#uscita = open("tabelline.csv","w")
#scrittore = csv.writer(uscita)
#for tab in range(1,11):
    #lista = []
    #for elem in range(1,11):
        #res= elem*tab
        #lista.append(res)
    #scrittore.writerow(lista)
#uscita.close()

######
# interazioni con il filesystem: può essere necessario interagire con il filesystem
# allo scopo di ricavare informazioni sulla directory in cui il programma sta operando
# le funzioni dedicate a questo sono contenute nella libreria os
import os
# la directory in cui il programma sta operando si ottiene tramite getcwd
# (GET Current Working Directory)
posizione=os.getcwd()
print(posizione)

# è possibile cambiare la directory corrente con chdir (CHange DIRectory)
#os.chdir("/home/alex/Poli/courseware")

#test= open("in_pos_inziale.txt","w")
#test.close()

#test= open("/home/alex/Poli/courseware/in_pos_finale.txt","w")
#test.close()

# la ca
#os.unlink("/home/alex/Poli/courseware/FDI/in_pos_iniziale.txt")
#os.unlink("/home/alex/Poli/courseware/in_pos_finale.txt")
#os.mkdir("/home/alex/Poli/courseware/FDI/dir1")
#os.rmdir("/home/alex/Poli/courseware/FDI/dir1")

percorso_completo= os.path.join(posizione,"file.txt")
print(percorso_completo)

lista_file = os.listdir(posizione)
print(lista_file)

## gestione file e directory, modulo os
## os.getcwd() os.chdir(path) os.unlink() os.path.join()
## os.mkdir(), os.listdir() os.rmdir()
