# Interludio sulle librerie
# posso utilizzare una funzione da me scritta in un altro file (nell' esempio, 
# cassetta_attrezzi.py) tramite una direttiva che importa la definizione della
# funzione stessa :
from cassetta_attrezzi import incrementa
print(incrementa(4))

# Alternativamente, la sola direttiva import crea un contenitore opaco
# che contiene tutte le definizioni di funzioni presenti in cassetta_attrezzi.py

#import cassetta_attrezzi

# In questo caso, quando invoco la funzione, devo indicare che proviene da 
# quel contenitore. Lo faccio aggiungendo come prefisso al nome della funzione
# il nome del contenitore separato da un punto

# print(cassetta_attrezzi.incrementa(3))

# interludio: notazione con punto
# in python, ci sono funzioni builtin anche associate ad ogni contenitore 
# Ad esempio, per le liste:
lista=['a','b','c','d']

# append aggiunge in coda
lista.append(42)
print(lista)

# insert inserisce alla posizione data
lista.insert(0,"test")
print(lista)

# pop rimuove l' elemento alla posizione data, restituendolo
estratto=lista.pop(0)

print(lista)
print(estratto)
print(lista.index('c'))

# n.b. non creano un contenitore nuovo, agiscono su quello che c'è
lista2=lista
lista.pop(1)
print(lista2)

# Differenza evidente tra metodi del contenitore ed operatori: creazione o 
# meno di un nuovo contenitore

###############################################################################

# Nuovo contenitore: l' insieme (set)
# Contenitore Python che stocca un insieme di oggetti *unici*, privi di 
# ordine a priori
insieme={1,"gatto","cavallo",4}
print(insieme)

# attenzione, quando inserito in un insieme, un booleano viene visto come 
# coincidente con l' intero corrispondente: True -> 1 , False -> 0
# non posso inserire 1 e True o 0 e False
insieme={True,1}
print(insieme)
insieme={1,True}
print(insieme)

# può solo contenere oggetti immutabili, non è ammesso ad esempio un insieme
# di liste
# insieme={["elem","elem"]}
# print(insieme)

# ma è possibile costruire un insieme di tuple
insieme={("elem","elem")}
print(insieme)

# l' insieme vuoto non può essere dichiarato come {} per ragioni storiche
# si usa invece la seguente sintassi
insieme_vuoto=set()
print(insieme_vuoto, len(insieme_vuoto))

# non essendo ordinato, non ha senso usare le [] per accedere ad un elemento
# print(insieme[2])

# posso comunque iterare sugli elementi di un insieme, ma l' ordine con cui
# verranno scanditi dipende da come python li rappresenta in memoria
for elem in insieme:
    print(elem)

# gli operatori di somma e differenza agiscono come da aspettative 
# (creando un nuovo set)
insieme2={"cavallo"}
print(insieme-insieme2)
# l' operatore prodotto non è definito (non fa il cartesiano)
# print(insieme*insieme2)

#funzioni disponibili
insieme={"gatto","cavallo"}

# add aggiunge un elemento
insieme.add("tartaruga")
# discard rimuove un elemento, se non è presente, non succede nulla
insieme.discard("cavallo") 
insieme.discard("cane") # non necessariamente presente
# remove rimuove un elemento, se non è presente causa un errore 
#insieme.remove("cane") # deve essere presente

print(insieme.intersection(insieme2))
print(insieme.union(insieme2))


# Esempio di uso di un insieme: costruire un vocabolario di parole a partire da un
# testo dato 
testo = """
Guybrush: How much wood could a woodchuck chuck if a woodchuck could chuck wood?
Woodchuck: A woodchuck could chuck no amount of wood since a woodchuck couldn't chuck wood.
Guybrush: But if a woodchuck could chuck and would chuck some amount of wood, what amount of wood would a woodchuck chuck?
Woodchuck: Even if a woodchuck could chuck wood, and even if a woodchuck would chuck wood, should a woodchuck chuck wood?
Guybrush: A woodchuck should chuck if a woodchuck could chuck wood, as long as a woodchuck would chuck wood.
"""
lettere(list(testo))
parole=list(testo.split())
print(len(prova))
lessico=set(prova)
print(len(lessico))


############################################################################
# Nuovo contenitore: dizionario 
# contenitori di coppie chiave-valore 
# chiave: generalizzazione dell' idea di indice: deve essere unica, non 
# necessariamente con relazione d' ordine

# dichiaro gli elementi come chiave:valore, separati da virgola , tra graffe

numero_zampe = {"serpente" : 0, "cane" : 4, "ragno": 8}
print(numero_zampe)
dizionario_vuoto = {}

#accedere ad un elemento ha sintassi simile a quella di un accesso a lista
numero_zampe["serpente"] = 0.5
print(numero_zampe["serpente"])

# posso aggiungere nuovi elementi semplicemente assegnando un valore
numero_zampe["anatra"]=2
print(numero_zampe)

#più chiavi possono corrispondere allo stesso valore
numero_zampe["gatto"]=4
print(numero_zampe)

# posso iterare sugli elementi di un dizionario: il ciclo for copierà le 
# *chiavi* nella variabile di iterazione
for animale in numero_zampe:
    print(animale + " ha " + str(numero_zampe[animale]) + " zampe")

print(numero_zampe.items())
print(numero_zampe.values())

# funzioni disponibili:
# pop rimuove un elemento, nella fattispecie rimuove una chiave (attenzione, 
# il valore corrispondente potrebbe essere condiviso con altre chiavi, non viene
# rimosso)
numero_zampe.pop("gatto")

# esercizio: stampare tutte le chiavi di un dizionario con un dato valore
