# Contenitori
# Python dispone di 4 tipi di contenitori built-in: 
# 1) liste, 
# 2) tuple, 
# 3) insiemi e 
# 4) dizionari

# In questa lezione trattiamo Liste e tuple
# una lista, come implica il nome è un contenitore di una sequenza ordinata
# di oggetti (= variabili)

lista = [1,2,'3',4,5,6]
elem = lista[2]
print(type(elem))

## posso modificare gli elementi di una lista (sintassi uguale a quella per manipolare
## i caratteri di una stringa)
lista[2] =24
print(lista)

## ma non di una tupla! Una lista è mutevole (mutable), una tupla è immutabile
#tupla[2] =24
#print(tupla)

# l' operatore : si comporta come da attese
print(lista[0:2])
# idem per concatenazione + e replicazione *
porzione = lista[0:2] 
print(porzione+porzione+porzione)
print(3*porzione)

# attenzione a non confondere 3 (intero) con [3] (lista che contiene un intero)
porzione = porzione + [ 3 ]
porzione = [porzione[0]] + [3] + [porzione[1]]
print(porzione)

lista = [1,2,4,5,6]
lista = lista[0:2] + [3] + lista[2:5]

# attenzione a non confondere una sottolista da un solo elemento con l' elemento
# in quella posizione

# la seguente riga stampa una lista di un solo elemento
print(lista[0:1])
# la seguente riga stampa un elemento
print(lista[0])


# funzionano gli operatori di confronto == e !=, e l' operatore in
lista2=[1,2,4,5,6]
print(lista==lista2)
lista2=[1,4,2,5,6]
print(lista!=lista2)
print(not(lista==lista2))

## assegnare ad un elemento inesistente di una lista non lo crea
#lista[4] = 9
print(lista)
# e non è possibile accederci
a = lista[6]

# Differenza tra un contenitore mutevole ed una variabile di tipo base: la variabile 
# contenitore non contiene i dati, contiene un riferimento a dove essi si trovano
l = [1,2,3]
# l' assegnamento effettua una copia del solo riferimento (shallow copy)
l1 = l
l1[0] = 4

print("l1 contiene")
print(l1)

# per effettuare una copia dei contenuti, devo creare una nuova lista a partire
# da quelli esistenti. 
# posso farlo manualmente...
l2= []
for elem in l:
    l2 = l2 + [elem]

# Oppure usare la funzione built-in list() crea una lista con tutti gli
# elementi contenuti in un contenitore
lista3 = list(l2)
lista3[0]=1
print(lista3)

# lo stesso built-in consente di "trasformare" una tupla in una lista
tupla=("a","b","c")
lista3 = list(tupla)
print(lista3)

# len funziona anche sulle liste
print(len(lista3))

# interazioni tra liste e funzioni: contenitori mutevoli come parametro 
# viene passato un riferimento al contenitore: i dati manipolati sono
# quelli del parametro attuale, non una copia!
def cambia(x):
    x[0]=9
    return 
sequenza=[4,3,2,1]
cambia(sequenza)
print(sequenza)

# Attenzione a quando si cambia il contenitore a cui fa riferimento il 
# parametro formale: è una variabile nuova
def non_cambia(x):
    x=x+x #crea una nuova lista come risultato dell' operatore +
    return x

sequenza=[4,3,2,1]
seq2=non_cambia(sequenza)
print("Parametro post chiamata")
print(sequenza)
print("Lista ritornata")
print(seq2)


# liste di liste: come rappresentare tabelle.
matrice = [ [1,0,1], [1,1,0], [0,0,1] ]
def stampa_matrice(m):
    for riga in m:
        #print(riga)
        testo_da_stampare = "["
        for elem in riga:
            testo_da_stampare = testo_da_stampare + " " + str(elem) 
        testo_da_stampare=testo_da_stampare + " ]"
        print(testo_da_stampare)
    return

stampa_matrice(matrice)

# attenzione al funzionamento di len con una "matrice"
print(len(matrice))

# attenzione alla coerenza delle lunghezze delle righe nelle liste di liste 
spaiata=[[2,4,5],[1,3,5,7]]
print(spaiata)
print(len(spaiata))
print(len(spaiata[0]))
print(len(spaiata[1]))