# Funzioni
# In linea di principio, tutto il codice di un programma potrebbe essere scritto
# in un solo file .py, ma: 
#  -- E' difficile da manutenere
#  -- Non e' possibile riusare solo una porzione

# Python ci consente di suddividere il programma in sottoprogrammi. La sintassi
# per codificare un sottoprogramma è quella delle funzioni

# Per usare una funzione già esistente:
# invocazione (nota anche come chiamata) di una funzione
# sintassi simile alla matematica, ma semantica operativa
# valutare il risultato della chiamata corrisponde al calcolo della funzione 
print(3,"ciao",True)

# sintassi della composizione di funzioni per indicare che, alla chiamata della 
# funzione più esterna viene fornito come parametro il risultato di 
# quella interna

# Sono operativamente equivalenti
testo=input("lato?") 
n=int(testo)
# e:
n = int(  input("lato?")  )

# In una chiamata a funzione posso indicare un'espressione : verrà calcolata
# ed il risultato passato come parametro. Sono equivalenti:
testo='41'
tmp=int(testo)
numero=tmp+1
print(numero)

# e:
testo='41'
numero=int(testo)+1
print(numero)

# ed anche:
print(int(testo)+1)

# per creare una nuova funzione è necessario definirla. Python riserva la parola
# chiave "def" per indicare la definizione di una funzione.
# parti della definizione di una funzione: 
#  intestazione: è formata dalla parola chiave "def", dal nome della funzione
#                e dai parametri formali, racchiusi tra parentesi tonde e 
#                separati da virgola
# corpo della funzione: porzione di codice, scritta con un livello di rientro rispetto
#                       alla parola chiave "def", è il codice che viene eseguito
#                       quando la funzione viene chiamata. L' esecuzione della
#                       funzione termina quando viene incontrata la parola chiave
#                       return. il risultato del calcolo della funzione è ciò che
#                       segue la parola chiave return

def quadrato(x):
    risultato = x**2
    return risultato

# definire una funzione non implica che venga eseguita. Affinchè venga eseguita
# essa deve essere chiamata almeno una volta

# Ecco una chiamata alla funzione appena definita:
a=5
tmp=quadrato(a)
print(tmp)
# in alternativa  
print(quadrato(a))

# un altro esempio di definizione e chiamata di funzione
def incrementa(x):
    x=x+1
    return x

a = 10
print(incrementa(a))

# riorganizziamo la stampa delle tabelline con le funzioni

def stampa_tabellina(n,num_tabellina):
    testo_da_stampare=""
    for col in range(1,n+1):
        num_moltiplicato = col*num_tabellina
        testo_da_stampare = testo_da_stampare + ' ' + str( num_moltiplicato )
    print(testo_da_stampare)
    return 

n=12
for num_tabellina in range(1,n+1):
    stampa_tabellina(n,num_tabellina)

# N.B: viene fatta una copia del parametro passato alla funzione al momento della
#      chiamata. Questa copia è ad uso esclusivo della funzione ed è distrutta
#      alla fine dell' esecuzione della funzione stessa

def incremento(x):
    x=x+1
    return x
# il valore di a non è alterato dalla chiamata a incremento
a=5
b= incremento(a)
print(a,b)

# vale anche per le stringhe
def accorcia(s):
    s = s[0:2]
    return s

parola="ciao"
parola2= accorcia(parola)
print(parola,parola2)