/**
 * Informatica ed Elementi di Informatica Medica
 * ---------------------------------------------------------------------------
 * Esercizio 4.21
 *
 * Date le strutture dati personalizzate definite nell’esercizio 19, scrivere 
 * un programma in cui si simuli di operare su una scansione X-ray effettuata 
 * in corrispondenza di un dato organo.
 * Si immagini che l’immissione di un opportuno liquido di contrasto determini 
 * il completo oscuramento dei vasi sanguigni (RGB=0,0,0) nell’immagine proiettata
 * sullo schermo.
 * Il programma dovrà procedere con la localizzazione dei vasi sanguigni all’interno
 * dell’immagine.
 * Per semplicità, si immagini di operare su ingrandimento con risoluzione 4x4 pixel.
 */

#include <stdio.h>

typedef unsigned char pixel[3];

typedef struct {
	unsigned int dim_x;
	unsigned int dim_y;
	pixel immagine[4][4];
} image4x4;


image4x4 scansione_tessuto = { 4, 4,
	{
		{{ 210, 104, 85 }, {   0,   0,  0 }, { 210, 104, 85 }, { 210, 104, 85 }},
		{{ 210, 104, 85 }, {   0,   0,  0 }, { 210, 104, 85 }, { 210, 104, 85 }},
		{{ 210, 104, 85 }, { 210, 104, 85 }, {   0,   0,  0 }, { 210, 104, 85 }},
		{{ 210, 104, 85 }, { 210, 104, 85 }, { 210, 104, 85 }, {   0,   0,  0 }}
	}
};

void localizza_vaso_sanguigno(image4x4 * scansione) {
	unsigned int x, y;
	for (x = 0; x < scansione->dim_x; x++) {
		for (y = 0; y < scansione->dim_y; y++) {
			if (scansione->immagine[x][y][0] == 0
					&& scansione->immagine[x][y][1] == 0
					&& scansione->immagine[x][y][2] == 0)
				printf("Vaso sanguigno in [x=%d,y=%d]\n", x, y);
		}
	}
}

int main() {
	localizza_vaso_sanguigno(&scansione_tessuto);
	return 0;
}

