/**
 * Informatica ed Elementi di Informatica Medica
 * ---------------------------------------------------------------------------
 * Esercizio 4.18
 *
 * Scrivere un programma che permetta di tenere traccia di un registro pazienti,
 * stampare le informazioni di ogni paziente, ed effettuare ricerche per tipologia
 * di disturbo.
 * A tal scopo si definisca un tipo personalizzato paziente, che includa un
 * codice identificativo, nome, cognome, anni e disturbo del paziente.
 */

#include <stdio.h>
#include <string.h>

typedef struct {
	unsigned int codice_id;
	char nome[15];
	char cognome[15];
	unsigned int anni;
	char disturbo[20];
} paziente;


paziente registro_pazienti[] = {
	{ 100, "Giuseppe", "Mannari", 20, "Raffreddore" },
	{ 105, "Francesca", "Rossi", 25, "Osteoporosi" },
	{ 110, "Alessandro", "Barelli", 50, "Colite" },
	{ 127, "Davide", "Zotti", 39, "Colite" },
	{ 155, "Michele", "Zamella", 40, "Raffreddore" }
};


void stampa_info_paziente(paziente * paz) {
	printf("%d %s %s %d %s\n",
		paz->codice_id,
		paz->nome,
		paz->cognome,
		paz->anni,
		paz->disturbo);
}


void stampa_archivio(paziente * registro, unsigned int dim) {
	int i;
	for (i = 0; i < dim; i++)
		stampa_info_paziente(&registro[i]);
}


void cerca_pazienti_per_disturbo(paziente * registro, unsigned int dim, char * disturbo) {
	int i ;
	for (i = 0; i < dim; i++) {
		int risultato = strcmp(registro[i].disturbo, disturbo);
		if (risultato == 0) {
			stampa_info_paziente(&registro[i]);
		}
	}
}


int main() {
	stampa_archivio(registro_pazienti, 5);
	printf("\nRicerca per disturbo...\n");
	cerca_pazienti_per_disturbo(registro_pazienti, 5, "Colite");
	return 0;
}
