#include <stdio.h>

#define MAX_N 100

int getint(void) {
	char input;
	int num = 0;
	
	// Prendo il primo carattere
	input = getchar();
	// Ad ogni ciclo converto il singolo carattere in cifra numerica
	while(input!='\n'){
		// Rimuovo l'offset del carattere ASCII '0' (=48)
		input = input - '0';
		// Sposto le cifre già inserite nelle posizioni più significative
		num = 10*num + input;
		// Ricevo il nuovo carattere
		input = getchar();	
	}
	return num;
}

int matrice[MAX_N][MAX_N];

void stampa_matrice(int N) {

	FILE *f = fopen("matrice.txt", "w");

	int i, j;

	if (f == NULL) {
		putchar('N');
		putchar('\n');
		return;
	}

	for (i=0; i<N; i++) {
		for (j=0; j<N; j++) {
			fputc(matrice[i][j] + '0', f);
			fputc(' ', f);
		}
		fputc('\n', f);
	}

	fclose(f);
}

int main() {

	int i, N = getint();

	if ( N > MAX_N ) {
		putchar('N');
		putchar('\n');
		return 1;
	}

	for (i=0; i<N; i++) {
		matrice[i][i] = 1;
	}

	stampa_matrice(N);

	return 0;
}
