#include <stdio.h>
#include <string.h>

#define MAX_LENGTH 255

struct elenco_item {
	char nome[MAX_LENGTH];
	char cognome[MAX_LENGTH];
	int eta;
};

int main() {

	FILE *f = fopen("elenco2.bin", "rb");

	if (f == NULL) {
		putchar('N');
		putchar('\n');
		return 1;
	}


	int N;
	int s = fread(&N, sizeof(int), 1, f);

	int i, checksum = 0;

	for (i=0; i<N; i++) {
		struct elenco_item persona;
		fread(&persona, sizeof(struct elenco_item), 1, f);
		printf("%s %s (%d) \n", persona.nome, persona.cognome, persona.eta);
		checksum = checksum ^ persona.eta;
	}

	// Usiamo N per il checksum
	fread(&N, sizeof(struct elenco_item), 1, f);

	if (checksum == N) {
		puts("Checksum corretto!");
	} else {
		puts("Checksum errato!");
	}

	fclose(f);
	return 0;
}
