#include <stdio.h>
#include <math.h>

#define N 40 	// 20 + 20 e' abbastanza per il codominio

struct xy {
	int x;
	int y;
};

int matrice[N][N];

struct xy heart_function(int t) {

	struct xy heart_point;

	heart_point.x = 16 * pow(sin(t), 3);
	heart_point.y = 13 * cos(t) - 5*cos(2*t) - 2*cos(3 *t) - cos(4*t);

	// Codominio:
	// x \in [-16; 16]
	// y \in [-5;5]

	return heart_point;	
}


void stampa_matrice(void) {

	FILE *f = fopen("cuore.txt", "w");

	if (f == NULL) {
		putchar('N');
		putchar('\n');
		return;
	}

	for (int i=0; i<N; i++) {
		for (int j=0; j<N; j++) {
			if (matrice[i][j] == 0)
				fputc(' ', f);
			else
				fputc(matrice[i][j] + '0', f);
			fputc(' ', f);
		}
		fputc('\n', f);
	}

	fclose(f);
}

int main() {


	for (int t=-50; t<50; t++) {
		// Due operazioni:
		// - traslare tutto nel primo quadrante (x positiva, y positiva)
		// - cambiare l'orientamento di y perche' l'asse delle ordinate
		//   nella matrice e' rivolto verso il basso!
		int x = N/2 + heart_function(t).x;
		int y = N/2 - heart_function(t).y;
		matrice[y][x] = 1;

	}

	stampa_matrice();

	return 0;
}
